

Public Class IDB_BACK

    Public fichero As String


    Public Sub IDB_GSI_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IDB_GSI.Click
        Ejecutar("GSI")
    End Sub
    Public Sub IDB_PSO_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IDB_PSO.Click
        Ejecutar("PSO")
    End Sub
    Private Sub Ejecutar(ByVal origen As String)
        Dim i, j, dirmeta As Integer
        Dim archivo As New System.IO.StreamReader(fichero)
        Dim linea, lfichsalida As String
        Dim despX, despY As Decimal
        Dim fallo, acierto As Int16
        Dim tiempo As Decimal
        Dim duracion As Decimal
        Dim cota As Int16

        If IDV_EXITDI.Text = "" Then
            IDV_EXITDI.Text = "c:\temp\"
        End If

        IDV_FAIL.Text = ""
        IDV_SUCCESS.Text = ""

        Habilitar(False)

        mundox = CInt(IDV_MUNDOX.Text)
        mundoy = CInt(IDV_MUNDOY.Text)
        colores = CInt(IDV_COLOR.Text)
        cota = CInt(IDV_COTA.Text)

        rmeta = CInt(IDV_RADIO.Text)
        metacuad = rmeta ^ 2

        While Not archivo.EndOfStream
            linea = archivo.ReadLine

            Dim words As String() = linea.Split(" "c)
            If words(0) = "p" Then
                If words(1) = "edge" Then
                    boids = CInt(words(2))
                    ReDim lBirds(boids - 1)
                    For i = 0 To boids - 1
                        lBirds(i).Vecinos = New Integer(boids) {}
                    Next
                Else
                    boids = CInt(words(1))
                    ReDim lBirds(boids - 1)
                    For i = 0 To boids - 1
                        lBirds(i).Vecinos = New Integer(boids) {}
                    Next
                End If
            End If
            If words(0) = "e" Then
                If words(2) = "" Then
                    lBirds(words(1).Trim - 1).Vecinos(words(3) - 1) = -999
                    lBirds(words(3) - 1).Vecinos(words(1) - 1) = -999
                Else
                    lBirds(words(1).Trim - 1).Vecinos(words(2) - 1) = -999
                    lBirds(words(2) - 1).Vecinos(words(1) - 1) = -999
                End If

            End If
        End While

        Dim r, re, t As Integer
        Dim it As Double
        r = CInt(IDV_REPE.Text)
        it = CDbl(IDV_ITERA.Text)

        IDV_INI.Text = Now

        If origen = "ACO" Then
            Dim hormigas As Double
            Dim antz As Integer

            lfichsalida = IDV_EXITDI.Text + "\" + CStr(r) + "_ACO_" + CStr(Today.Year()) + CStr(Today.Month()) + CStr(Today.Day()) + CStr(Now.Hour()) + CStr(Now.Minute()) + CStr(Now.Second()) + ".txt"
            FileOpen(1, lfichsalida, OpenMode.Output, OpenAccess.Write, OpenShare.Default)
            FileSystem.WriteLine(1, "ACO")
            FileSystem.WriteLine(1)

            IDB_REPE.Minimum = 0
            IDB_REPE.Maximum = r - 1
            IDB_REPE.Value = 0
            IDB_REPE.Step = 1

            For re = 1 To r
                IDB_REPE.PerformStep()

                hormigas = AntColony(it, cota, antz)

                If hormigas <= it Then
                    acierto = acierto + 1
                    IDV_SUCCESS.Text = acierto
                    FileSystem.WriteLine(1)
                    FileSystem.WriteLine(1, "Ants cicles: " + CStr(hormigas - 1) + " with *" + CStr(cota) + "* colors and " + CStr(antz) + " Ants used")
                    For i = 0 To boids - 1
                        FileSystem.Write(1, CStr(lBirds(i).Colour))
                    Next
                    If cota > colores Then
                        cota -= 1
                    End If
                Else
                    fallo = fallo + 1
                    IDV_FAIL.Text = fallo
                End If
                tiempo = tiempo + (hormigas - 1)

            Next
            IDV_FIN.Text = Now
            duracion = DateDiff(DateInterval.Second, CDate(IDV_INI.Text), Now)
            tiempo = (tiempo / r)

        End If

        confort = IDV_CONFORT.Text

        If origen = "PSO" Then
            lfichsalida = IDV_EXITDI.Text + "\" + CStr(r) + "_PSO_" + CStr(Today.Year()) + CStr(Today.Month()) + CStr(Today.Day()) + CStr(Now.Hour()) + CStr(Now.Minute()) + CStr(Now.Second()) + ".txt"
            FileOpen(1, lfichsalida, OpenMode.Output, OpenAccess.Write, OpenShare.Default)
            FileSystem.WriteLine(1, "PSO")
            FileSystem.WriteLine(1)

            cota = CInt(IDV_COLOR.Text)
            colores = CInt(IDV_COTA.Text)

            IDV_SUCCESS.Text = ParticleSwarmOptimization(r, it, tiempo, cota)
            IDV_FAIL.Text = r - CInt(IDV_SUCCESS.Text)

            acierto = IDV_SUCCESS.Text
            fallo = IDV_FAIL.Text
            IDV_FIN.Text = Now
            duracion = DateDiff(DateInterval.Second, CDate(IDV_INI.Text), Now)
            tiempo = (tiempo / r)
        End If

        If origen = "SA" Then
            Dim frio As Double
            Dim colorsol As Int16

            IDB_REPE.Minimum = 0
            IDB_REPE.Maximum = r - 1
            IDB_REPE.Value = 0
            IDB_REPE.Step = 1

            lfichsalida = IDV_EXITDI.Text + "\" + CStr(r) + "_SA_" + CStr(Today.Year()) + CStr(Today.Month()) + CStr(Today.Day()) + CStr(Now.Hour()) + CStr(Now.Minute()) + CStr(Now.Second()) + ".txt"
            FileOpen(1, lfichsalida, OpenMode.Output, OpenAccess.Write, OpenShare.Default)
            FileSystem.WriteLine(1, "SA")
            FileSystem.WriteLine(1)

            For re = 1 To r

                IDB_REPE.PerformStep()

                cota = CInt(IDV_COTA.Text)

                colorsol = cota

                IDB_ITERA.Maximum = cota - 1
                IDB_ITERA.Minimum = 0
                IDB_ITERA.Value = 0
                IDB_ITERA.Step = 1

                While colorsol > 0

                    IDB_ITERA.PerformStep()

                    frio = simulated_anealing(it, cota, colorsol)
                    If frio < it And cota <> colores Then
                        FileSystem.WriteLine(1, "Colors: " + CStr(cota) + " in cicle: " + CStr(frio - 1))
                    End If
                    cota = colorsol
                End While

                If frio < it Then
                    acierto = acierto + 1
                    IDV_SUCCESS.Text = acierto
                    FileSystem.WriteLine(1, "Cicles of Simulated Annealing: " + CStr(frio - 1) + " execution " + CStr(re) + " colors:" + CStr(colores))
                    For i = 0 To boids - 1
                        FileSystem.Write(1, CStr(lBirds(i).Colour))
                    Next
                    FileSystem.WriteLine(1)
                    FileSystem.WriteLine(1)
                Else
                    fallo = fallo + 1
                    IDV_FAIL.Text = fallo
                End If
                tiempo = tiempo + (frio - 1)
            Next
            IDV_FIN.Text = Now
            duracion = DateDiff(DateInterval.Second, CDate(IDV_INI.Text), Now)
            tiempo = (tiempo / r)
        End If

        If origen = "TABU" Then
            Dim tabus As Integer

            lfichsalida = IDV_EXITDI.Text + "\" + CStr(r) + "_TABU_" + CStr(Today.Year()) + CStr(Today.Month()) + CStr(Today.Day()) + CStr(Now.Hour()) + CStr(Now.Minute()) + CStr(Now.Second()) + ".txt"
            FileOpen(1, lfichsalida, OpenMode.Output, OpenAccess.Write, OpenShare.Default)
            FileSystem.WriteLine(1, "TABU")
            FileSystem.WriteLine(1)

            IDB_REPE.Minimum = 0
            IDB_REPE.Maximum = r - 1
            IDB_REPE.Value = 0
            IDB_REPE.Step = 1

            cota = CInt(IDV_COLOR.Text)
            colores = CInt(IDV_COTA.Text)

            For re = 1 To r
                IDB_REPE.PerformStep()

                If IDC_ESP.Checked = True Then
                    tabus = Tabu_Search(it, 1)
                Else
                    tabus = Tabu_Search(it, 0)
                End If

                If tabus < it Then
                    acierto = acierto + 1
                    IDV_SUCCESS.Text = acierto
                    FileSystem.WriteLine(1)
                    If IDC_ESP.Checked = True Then
                        FileSystem.WriteLine(1, "TabusEsp: " + CStr(tabus) + " execution " + CStr(re) + " colors " + CStr(colores))
                    Else
                        FileSystem.WriteLine(1, "Tabus: " + CStr(tabus) + " execution " + CStr(re) + " colors " + CStr(colores))
                    End If
                    For i = 0 To boids - 1
                        FileSystem.Write(1, CStr(lBirds(i).Colour))
                    Next
                    FileSystem.WriteLine(1)
                    FileSystem.WriteLine(1)
                    If colores > cota Then
                        colores -= 1
                    End If
                Else
                    fallo = fallo + 1
                    IDV_FAIL.Text = fallo
                End If
                tiempo = tiempo + tabus
            Next
            IDV_FIN.Text = Now
            duracion = DateDiff(DateInterval.Second, CDate(IDV_INI.Text), Now)

            tiempo = (tiempo / r)

        End If

        If origen = "BRELAZ" Then

            Dim dsatmaxcol As Int16
            Dim randombre As New Random()
            Dim varran As Int16
            dsatmaxcol = brelaz_algorithm()
            dsatmaxcol = dsatmaxcol + 1
            varran = randombre.Next(1, 999)

            lfichsalida = IDV_EXITDI.Text + "\" + CStr(dsatmaxcol) + "_" + CStr(varran) + "_BRELAZ_" + CStr(Today.Year()) + CStr(Today.Month()) + CStr(Today.Day()) + CStr(Now.Hour()) + CStr(Now.Minute()) + CStr(Now.Second()) + ".txt"
            FileOpen(1, lfichsalida, OpenMode.Output, OpenAccess.Write, OpenShare.Default)
            FileSystem.WriteLine(1, "BRELAZ")
            FileSystem.WriteLine(1)

            FileSystem.WriteLine(1, "Dsatur Colors used:" + CStr(dsatmaxcol))
            For i = 0 To boids - 1
                FileSystem.Write(1, CStr(lBirds(i).Colour))
            Next
            FileSystem.WriteLine(1)
            FileSystem.WriteLine(1)
            IDV_SUCCESS.Text = dsatmaxcol

            IDV_FIN.Text = Now
            duracion = DateDiff(DateInterval.Second, CDate(IDV_INI.Text), Now)

        End If

        If origen = "BACK" Or origen = "DSATUR" Then

            Dim back As Double
            ReDim lBrelazB(boids - 1)
            For i = 0 To boids - 1
                lBrelazB(i).Vecinos = New Integer(boids) {}
            Next

            If origen = "BACK" Then
                lfichsalida = IDV_EXITDI.Text + "\" + CStr(r) + "_BACK_" + CStr(Today.Year()) + CStr(Today.Month()) + CStr(Today.Day()) + CStr(Now.Hour()) + CStr(Now.Minute()) + CStr(Now.Second()) + ".txt"
                FileOpen(1, lfichsalida, OpenMode.Output, OpenAccess.Write, OpenShare.Default)
                FileSystem.WriteLine(1, "BACK")
                FileSystem.WriteLine(1)
            Else
                lfichsalida = IDV_EXITDI.Text + "\" + CStr(r) + "_DSATUR_" + CStr(Today.Year()) + CStr(Today.Month()) + CStr(Today.Day()) + CStr(Now.Hour()) + CStr(Now.Minute()) + CStr(Now.Second()) + ".txt"
                FileOpen(1, lfichsalida, OpenMode.Output, OpenAccess.Write, OpenShare.Default)
                FileSystem.WriteLine(1, "DSATUR")
                FileSystem.WriteLine(1)
            End If

            cota = CInt(IDV_COLOR.Text)
            colores = CInt(IDV_COTA.Text)

            While True
                If origen = "BACK" Then
                    back = backtrack_algorithm(it)
                Else
                    back = dsatur_algorithm(it)
                End If

                If cota = colores Or back = it Then
                    Exit While
                Else
                    FileSystem.WriteLine(1, "Backtraks: " + CStr(back) + " Colors:" + CStr(colores))
                    For i = 0 To boids - 1
                        FileSystem.Write(1, CStr(lBrelazB(i).X1))
                    Next
                    FileSystem.WriteLine(1)
                    FileSystem.WriteLine(1)
                    colores -= 1
                End If

            End While

            If back < it Then
                IDV_SUCCESS.Text = 1
                IDV_FAIL.Text = 0
            Else
                IDV_SUCCESS.Text = 0
                IDV_FAIL.Text = 1
            End If

            For i = 0 To boids - 1
                FileSystem.Write(1, CStr(lBrelazB(i).X1))
            Next
            FileSystem.WriteLine(1)

            r = 1
            acierto = IDV_SUCCESS.Text
            fallo = IDV_FAIL.Text
            tiempo = back
            IDV_FIN.Text = Now
            duracion = DateDiff(DateInterval.Second, CDate(IDV_INI.Text), Now)
        End If


        If origen = "GSI" Then

            ReDim lCiclo(boids - 1)
            ReDim lEnemigos(boids - 1)

            Dim colorsal As Int16
            Dim nuecolor As Int16

            lfichsalida = IDV_EXITDI.Text + "\" + CStr(r) + "_SWARM_" + CStr(Today.Year()) + CStr(Today.Month()) + CStr(Today.Day()) + CStr(Now.Hour()) + CStr(Now.Minute()) + CStr(Now.Second()) + ".txt"
            FileOpen(1, lfichsalida, OpenMode.Output, OpenAccess.Write, OpenShare.Default)
            FileSystem.WriteLine(1, "GSI")
            FileSystem.WriteLine(1)

            IDB_REPE.Minimum = 0
            IDB_REPE.Maximum = r - 1
            IDB_REPE.Value = 0
            IDB_REPE.Step = 1

            If IDC_ESP.Checked = True Then
                especial = True
            Else
                especial = False
            End If

            colores = CStr(IDV_COTA.Text)
            cota = CStr(IDV_COLOR.Text)

            For re = 1 To r ' repetir
                IDB_REPE.PerformStep()

                ReDim lMetas(colores - 1)
                ColocarMetas()

                For i = 0 To boids - 1
                    lBirds(i).Colour = 999
                    lBirds(i).Propuesta = 999
                    CalculoPos(i, True, colorsal, nuecolor)
                Next
                IDB_ITERA.Maximum = it - 1
                IDB_ITERA.Minimum = 0
                IDB_ITERA.Value = 0
                IDB_ITERA.Step = 1
                For t = 1 To it ' itera
                    IDB_ITERA.PerformStep()

                    For i = 0 To boids - 1 'mueve boid
                        dirmeta = lBirds(i).Direccion

                        despX = lBirds(i).X2 - lBirds(i).X1
                        despY = lBirds(i).Y2 - lBirds(i).Y1

                        lBirds(i).X1 = lBirds(i).X2
                        lBirds(i).Y1 = lBirds(i).Y2
                        lBirds(i).X2 = lBirds(i).X2 + despX
                        lBirds(i).Y2 = lBirds(i).Y2 + despY

                        If lBirds(i).X1 < 0 Then
                            lBirds(i).X1 = lBirds(i).X1 + mundox
                            lBirds(i).X2 = lBirds(i).X2 + mundox
                        End If
                        If lBirds(i).Y1 < 0 Then
                            lBirds(i).Y1 = lBirds(i).Y1 + mundoy
                            lBirds(i).Y2 = lBirds(i).Y2 + mundoy
                        End If
                        If lBirds(i).X1 > 100 Then
                            lBirds(i).X1 = lBirds(i).X1 - mundox
                            lBirds(i).X2 = lBirds(i).X2 - mundox
                        End If
                        If lBirds(i).Y1 > 100 Then
                            lBirds(i).Y1 = lBirds(i).Y1 - mundoy
                            lBirds(i).Y2 = lBirds(i).Y2 - mundoy
                        End If

                        If Distancia(lMetas(dirmeta).PosX, lBirds(i).X1, lMetas(dirmeta).PosY, lBirds(i).Y1) Then
                            lBirds(i).Colour = dirmeta
                        Else
                            lBirds(i).Colour = 999
                        End If
                    Next 'mueve boid
                    ' Se comprueba la direccion de cada pajaro y se marca como alterada si es preciso
                    For i = 0 To boids - 1
                        AtraccionMeta(i)
                    Next

                    ' Asigna a un pajaro su nueva direccin si la tiene y si esta dentro del color de la nueva direccion
                    ' Sino lo ignora
                    For i = 0 To boids - 1 ' nueva dir
                        dirmeta = lBirds(i).Propuesta
                        If dirmeta <> 999 Then
                            lBirds(i).Direccion = dirmeta
                            If Distancia(lMetas(dirmeta).PosX, lBirds(i).X1, lMetas(dirmeta).PosY, lBirds(i).Y1) Then
                                lBirds(i).Colour = dirmeta
                            Else
                                lBirds(i).Colour = 999
                                lBirds(i).Propuesta = 999
                            End If
                        End If
                    Next 'nueva dir

                    ' Chequea si la coloracion actual resulve el problema
                    If Resuelto() = 0 Then
                        ' Escribe la solucion en un fichero de salida
                        FileSystem.WriteLine(1)
                        FileSystem.WriteLine(1, "Solved in time " + CStr(t) + " of the repetition:" + CStr(re) + " with " + CStr(colores) + " colors and radius " + CStr(rmeta))
                        For j = 0 To boids - 1
                            FileSystem.Write(1, CStr(lBirds(j).Colour))
                        Next
                        FileSystem.WriteLine(1)
                        'For j = 0 To boids - 1
                        '    FileSystem.Write(1, "S", CStr(lBirds(j).Stress))
                        'Next
                        tiempo = tiempo + t
                        Exit For
                    End If
                Next ' itera

                ' Si se ha llegado al maximo de iteraciones el programa se para y da el problema como no resuelto
                If t >= it Then
                    ' Escribe en un fichero de salida que no ha encontrado la soucion
                    tiempo = tiempo + it
                    fallo = fallo + 1
                    IDV_FAIL.Text = fallo
                    Refresh()
                Else
                    acierto = acierto + 1
                    IDV_SUCCESS.Text = acierto
                    If colores > cota Then
                        colores -= 1
                    End If
                End If
            Next ' repetir

            tiempo = (tiempo / r)
            duracion = DateDiff(DateInterval.Second, CDate(IDV_INI.Text), Now)
        End If

        tiempo = Math.Round(tiempo, 1)

        FileSystem.WriteLine(1)
        FileSystem.WriteLine(1, " Repetitions:" + CStr(r) + " Success:" + CStr(acierto) + " Fails:" + CStr(fallo) + " Average cicles:" + CStr(tiempo))
        FileSystem.WriteLine(1)
        FileSystem.WriteLine(1, "Time: " + CStr(duracion))
        FileSystem.WriteLine(1)
        FileSystem.WriteLine(1, fichero)
        FileClose(1)
        Habilitar(True)
        IDV_FIN.Text = Now
        'MessageBox.Show("Terminado con " + CStr(acierto) + " aciertos")

    End Sub

    Private Sub Habilitar(ByVal bool As Boolean)

        IDB_GSI.Enabled() = bool
        IDB_PSO.Enabled() = bool
        btnSalir.Enabled() = bool
        btnBack.Enabled() = bool
        btnDsatur.Enabled() = bool
        btnTabu.Enabled() = bool
        btnSA.Enabled() = bool
        btnAco.Enabled() = bool

    End Sub

    Private Sub Btn2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSalir.Click
        Close()
    End Sub


    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click

        Dim OpenFileDialog1 As New OpenFileDialog
        OpenFileDialog1.InitialDirectory = "D:\swarm"
        OpenFileDialog1.Filter = "Grafos (*.col)|*.col"
        OpenFileDialog1.ShowDialog()
        fichero = OpenFileDialog1.FileName

        IDV_FILE.Text = fichero

    End Sub


    Public Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnBack.Click

        Ejecutar("BACK")

    End Sub

    Public Sub btnDsatur_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDsatur.Click

        Ejecutar("DSATUR")

    End Sub

    Public Sub btnTabu_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnTabu.Click

        Ejecutar("TABU")

    End Sub

    Public Sub btnSA_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSA.Click

        Ejecutar("SA")

    End Sub

    Public Sub btnAco_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAco.Click
        Ejecutar("ACO")

    End Sub

    Private Sub IDB_KRG_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IDB_KRG.Click
        Dim lkuraA, lkuraB, lkuraC As String()
        Dim nodos, i, j, aristas, clique As Int16
        Dim repe, re As Int16

        aristas = CInt(IDV_EDGES.Text)
        nodos = CInt(IDV_NODES.Text)
        clique = CInt(IDV_KRG.Text)
        repe = CInt(IDV_REPEGEN.Text)

        If (nodos * 3) - 2 < aristas Then
            MessageBox.Show("Impossible to draw a KRG graph with so many edges")
            Return
        End If

        If nodos < clique Then
            MessageBox.Show("Impossible to draw a graph with so litle nodes")
            Return
        End If

        ReDim lkuraA(aristas)
        ReDim lkuraB(aristas)
        Dim nodoaux, salir, salida, sal As Int16
        Dim Random As New Random()

        salida = 0
        For re = 1 To repe
            ReDim lkuraC(clique - 1)
            sal = Kuratowski(lkuraA, lkuraB, aristas, nodos)
            salida = salida + sal
            If sal = 0 Then
                Continue For
            End If

            i = 0
            While True
                nodoaux = Random.Next(1, nodos + 1)
                salir = 0
                For j = 0 To i
                    If lkuraC(j) = nodoaux Then
                        salir = 1
                        Exit For
                    End If
                Next
                If salir = 0 Then
                    lkuraC(i) = nodoaux
                Else
                    Continue While
                End If

                i = i + 1

                If i = clique Then
                    Exit While
                End If

            End While

            Dim nueva_dim, newarista As Int16
            newarista = aristas
            nueva_dim = clique * (clique - 1) / 2
            nueva_dim = nueva_dim + aristas
            ReDim Preserve lkuraA(nueva_dim)
            ReDim Preserve lkuraB(nueva_dim)
            For i = 0 To clique - 2
                For j = 1 To clique - i - 1
                    newarista = newarista + 1
                    lkuraA(newarista) = lkuraC(i)
                    lkuraB(newarista) = lkuraC(i + j)
                Next
            Next

            Kura_a_fichero(re, nodos, nueva_dim, lkuraA, lkuraB, 1)
        Next

        MessageBox.Show("KRG Generated " + CStr((salida)), "Swarm", MessageBoxButtons.OK)

    End Sub

    Private Sub IDB_KURA_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IDB_KURA.Click
        Dim lkuraA, lkuraB As String()
        Dim aristas, nodos, repe, re As Int16
        aristas = CInt(IDV_EDGES.Text)
        nodos = CInt(IDV_NODES.Text)

        If (nodos * 3) - 2 < aristas Then
            MessageBox.Show("Impossible to draw a KRG graph with so many edges")
            Return
        End If

        If aristas > (nodos * (nodos - 1) / 2) Then
            MessageBox.Show("Too many edges")
            Return
        End If

        ReDim lkuraA(aristas)
        ReDim lkuraB(aristas)
        Dim salida, sal As Int16
        salida = 0

        repe = CInt(IDV_REPEGEN.Text)
        For re = 1 To repe
            sal = Kuratowski(lkuraA, lkuraB, aristas, nodos)
            salida = salida + sal
            If sal = 1 then
                Kura_a_fichero(re, nodos, aristas, lkuraA, lkuraB, 0)
            End If
        Next

        MessageBox.Show("Generated " + CStr((salida)), "Swarm", MessageBoxButtons.OK)

    End Sub

    Private Function Kuratowski(ByRef lkuraA As String(), ByRef lkuraB As String(), ByVal aristas As Int16, ByVal nodos As Int16) As Int16
        Dim asignadas, a, b, i, j, k, l, m, n As Int16
        Dim lkura1, lkura2, lkura3, lkura4, lkura5 As String()
        Dim yaesta As Boolean
        Dim aux1, aux2, k1, k2, k3, k4 As Int16

        ReDim lkuraA(aristas)
        ReDim lkuraB(aristas)
        ReDim lkura1(aristas)
        ReDim lkura2(aristas)
        ReDim lkura3(aristas)
        ReDim lkura4(aristas)
        ReDim lkura5(aristas)

        Dim Random As New Random()

        asignadas = 0
        While True
            a = Random.Next(1, nodos + 1)
            b = Random.Next(1, nodos + 1)

            If a = b Then
                Continue While
            End If
            yaesta = False

            For i = 1 To asignadas
                If (lkuraA(i) = a) And (lkuraB(i) = b) Or (lkuraA(i) = b) And (lkuraB(i) = a) Then
                    yaesta = True
                    Exit For
                End If
            Next

            If Not yaesta Then
                asignadas = asignadas + 1
                lkuraA(asignadas) = a
                lkuraB(asignadas) = b
            End If

            If asignadas = aristas Then
                Exit While
            End If
        End While

        ' Chequeo K5
        aux1 = 0
        For i = 1 To nodos 'For k1
            k1 = 0

            For j = 1 To aristas
                If lkuraA(j) = i Then
                    k1 = k1 + 1
                    lkura1(k1) = lkuraB(j)
                End If
                If lkuraB(j) = i Then
                    k1 = k1 + 1
                    lkura1(k1) = lkuraA(j)
                End If
            Next

            If k1 < 4 Then
                Continue For
            End If

            For j = 1 To k1 ' For k2
                If i = j Then
                    Continue For
                End If

                k2 = 0
                For k = 1 To aristas
                    If lkuraA(k) = i Or lkuraB(k) = i Then
                        Continue For
                    End If
                    If lkuraA(k) = lkura1(j) Then
                        yaesta = False
                        For n = 1 To k1
                            If lkuraB(k) = lkura1(n) Then
                                yaesta = True
                            End If
                        Next
                        If yaesta Then
                            k2 = k2 + 1
                            lkura2(k2) = lkuraB(k)
                        End If
                    End If
                    If lkuraB(k) = lkura1(j) Then
                        yaesta = False
                        For n = 1 To k1
                            If lkuraA(k) = lkura1(n) Then
                                yaesta = True
                            End If
                        Next
                        If yaesta Then
                            k2 = k2 + 1
                            lkura2(k2) = lkuraA(k)
                        End If
                    End If
                Next

                If k2 < 3 Then
                    Continue For
                End If

                For k = 1 To k2 ' For k3
                    If i = k Then
                        Continue For
                    End If
                    If j = k Then
                        Continue For
                    End If

                    k3 = 0
                    For l = 1 To aristas
                        If lkuraA(l) = i Or lkuraB(l) = i Then
                            Continue For
                        End If
                        If lkuraA(l) = lkura1(j) Or lkuraB(l) = lkura1(j) Then
                            Continue For
                        End If
                        If lkuraA(l) = lkura2(k) Then
                            yaesta = False
                            For n = 1 To k2
                                If lkuraB(k) = lkura2(n) Then
                                    yaesta = True
                                End If
                            Next
                            If yaesta Then
                                k3 = k3 + 1
                                lkura3(k3) = lkuraB(l)
                            End If
                        End If
                        If lkuraB(l) = lkura2(k) Then
                            yaesta = False
                            For n = 1 To k2
                                If lkuraA(k) = lkura2(n) Then
                                    yaesta = True
                                End If
                            Next
                            If yaesta Then
                                k3 = k3 + 1
                                lkura3(k3) = lkuraA(l)
                            End If
                        End If
                    Next
                    If k3 < 2 Then
                        Continue For
                    End If

                    For l = 1 To k3 ' For k4
                        If i = l Then
                            Continue For
                        End If
                        If j = l Then
                            Continue For
                        End If
                        If k = l Then
                            Continue For
                        End If

                        k4 = 0
                        For m = 1 To aristas
                            If lkuraA(m) = i Or lkuraB(m) = i Then
                                Continue For
                            End If
                            If lkuraA(m) = lkura1(j) Or lkuraB(m) = lkura1(j) Then
                                Continue For
                            End If
                            If lkuraA(m) = lkura2(k) Or lkuraB(m) = lkura2(k) Then
                                Continue For
                            End If
                            If lkuraA(m) = lkura3(l) Then
                                yaesta = False
                                For n = 1 To k3
                                    If lkuraB(k) = lkura3(n) Then
                                        yaesta = True
                                    End If
                                Next
                                If yaesta Then
                                    k4 = k4 + 1
                                    lkura4(k4) = lkuraB(m)
                                End If
                            End If
                            If lkuraB(m) = lkura3(l) Then
                                yaesta = False
                                For n = 1 To k3
                                    If lkuraA(k) = lkura3(n) Then
                                        yaesta = True
                                    End If
                                Next
                                If yaesta Then
                                    k4 = k4 + 1
                                    lkura4(k4) = lkuraA(m)
                                End If
                            End If
                        Next

                        If k4 > 0 Then
                            aux1 = 1
                        End If
                    Next 'End For k4
                Next ' End For k3
            Next ' End For k2   
        Next 'End For k1

        If aux1 = 1 Then
            ' Hay un clique k5, no es planar
            Return 0
        End If

        'Chequeo k33
        aux2 = 0
        For i = 1 To nodos ' For 1
            k1 = 0

            For j = 1 To aristas ' for 12
                If lkuraA(j) = i Then
                    k1 = k1 + 1
                    lkura1(k1) = lkuraB(j)
                End If
                If lkuraB(j) = i Then
                    k1 = k1 + 1
                    lkura1(k1) = lkuraA(j)
                End If
            Next ' fin for 12

            If k1 < 3 Then
                Continue For
            End If

            For j = 1 To nodos ' for 2
                If i = j Then
                    Continue For
                End If

                k2 = 0
                For k = 1 To aristas ' for 21
                    If lkuraA(k) = i Or lkuraB(k) = i Then
                        Continue For
                    End If
                    If lkuraA(k) = j Then
                        yaesta = False
                        For n = 1 To k1
                            If lkuraB(k) = lkura1(n) Then
                                yaesta = True
                            End If
                        Next
                        If yaesta Then
                            k2 = k2 + 1
                            lkura2(k2) = lkuraB(k)
                        End If
                    End If
                    If lkuraB(k) = j Then
                        yaesta = False
                        For n = 1 To k1
                            If lkuraA(k) = lkura1(n) Then
                                yaesta = True
                            End If
                        Next
                        If yaesta Then
                            k2 = k2 + 1
                            lkura2(k2) = lkuraA(k)
                        End If
                    End If
                Next ' for 21

                If k2 < 3 Then
                    Continue For
                End If

                For l = 1 To nodos ' for 3
                    If i = l Then
                        Continue For
                    End If
                    If j = l Then
                        Continue For
                    End If

                    k3 = 0
                    For k = 1 To aristas ' for 31
                        If lkuraA(k) = i Or lkuraB(k) = i Then
                            Continue For
                        End If
                        If lkuraA(k) = j Or lkuraB(k) = j Then
                            Continue For
                        End If
                        If lkuraA(k) = l Then
                            yaesta = False
                            For n = 1 To k1
                                If lkuraB(k) = lkura2(n) Then
                                    yaesta = True
                                End If
                            Next
                            If yaesta Then
                                k3 = k3 + 1
                                lkura3(k3) = lkuraB(k)
                            End If
                        End If
                        If lkuraB(k) = l Then
                            yaesta = False
                            For n = 1 To k1
                                If lkuraA(k) = lkura2(n) Then
                                    yaesta = True
                                End If
                            Next
                            If yaesta Then
                                k3 = k3 + 1
                                lkura3(k3) = lkuraA(k)
                            End If
                        End If
                    Next  ' for 31

                    If k3 < 3 Then
                        Continue For
                    End If

                    aux2 = 1

                Next ' for 3
            Next ' for 2
        Next ' fin for 1

        If aux2 = 1 Then
            ' Hay un clique k3,3, no es planar
            Return 0
        End If

        Return 1

    End Function

    Private Sub Kura_a_fichero(ByVal re As Int16, ByVal nodos As Int16, ByVal aristas As Int16, ByRef lkuraA As String(), ByRef lkuraB As String(), ByVal origen As Int16)

        Dim lfichsalida As String

        If origen = 1 Then
            lfichsalida = IDV_EXITDIR.Text + "\KRG" + CStr(Now.Hour()) + CStr(Now.Minute()) + CStr(Now.Second()) + CStr(re) + ".col"
        Else
            lfichsalida = IDV_EXITDIR.Text + "\Kuratowsky" + CStr(Now.Hour()) + CStr(Now.Minute()) + CStr(Now.Second()) + CStr(re) + ".col"
        End If

        FileOpen(1, lfichsalida, OpenMode.Output, OpenAccess.Write, OpenShare.Default)

        If origen = 1 Then
            Dim clique As Int16
            clique = CInt(IDV_KRG.Text)

            FileSystem.PrintLine(1, "c KRG Graph of inpired in Kuratowsky and generated by the GIC San Sebastin")
            FileSystem.PrintLine(1, "c the chromatic number of this graph is: " + CStr(clique))
        Else
            FileSystem.PrintLine(1, "c Planar Graph of Kuratowsky generated by the GIC San Sebastin")
        End If

        FileSystem.PrintLine(1, "c Israel Rebollo and Manuel Graa")
        FileSystem.PrintLine(1, "c Grupo de Inteligencia Computacional - Computational Imtelligence Group")
        FileSystem.PrintLine(1, "c http://www.ehu.es/ccwintco")
        FileSystem.PrintLine(1, "p edge " + CStr(nodos) + " " + CStr(aristas))

        Dim ordenauxA, ordenauxB, i, j As Int16

        For i = 1 To aristas - 1
            For j = i + 1 To aristas
                If lkuraA(i) > lkuraA(j) Then
                    ordenauxA = lkuraA(j)
                    ordenauxB = lkuraB(j)
                    lkuraA(j) = lkuraA(i)
                    lkuraB(j) = lkuraB(i)
                    lkuraA(i) = ordenauxA
                    lkuraB(i) = ordenauxB
                End If
            Next
        Next

        For i = 1 To aristas
            FileSystem.PrintLine(1, "e " + CStr(lkuraA(i)) + " " + CStr(lkuraB(i)))
        Next
        FileClose(1)

    End Sub

    Private Sub IDB_MIZUNO_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IDB_MIZUNO.Click

        Dim acciones As Int16
        Dim re, repe, nogen As Int16
        Dim i As Int16

        ReDim mug9(8)
        ReDim mug10(9)
        ReDim mug11a(10)
        ReDim mug11b(10)
        ReDim mug12a(11)
        ReDim mug12b(11)
        ReDim mug12c(11)
        For i = 0 To 8
            mug9(i).vecinos = New Integer(8) {}
        Next
        For i = 0 To 9
            mug10(i).vecinos = New Integer(9) {}
        Next
        For i = 0 To 10
            mug11a(i).vecinos = New Integer(10) {}
            mug11b(i).vecinos = New Integer(10) {}
        Next
        For i = 0 To 11
            mug12a(i).vecinos = New Integer(11) {}
            mug12b(i).vecinos = New Integer(11) {}
            mug12c(i).vecinos = New Integer(11) {}
        Next
        fun_mug9()
        fun_mug10()
        fun_mug11a()
        fun_mug11b()
        fun_mug12a()
        fun_mug12b()
        fun_mug12c()

        acciones = CInt(IDV_MIT.Text)

        repe = CInt(IDV_REPEGEN2.Text)
        nogen = 0

        Dim Random As New Random()

        For re = 1 To repe

            graph_generator(acciones, re, IDV_EXITDIR.Text)

        Next

        MessageBox.Show("Generated " + CStr((repe - nogen)), "Swarm", MessageBoxButtons.OK)

    End Sub

    Private Sub Button2_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IDB_EXIT2.Click
        Close()
    End Sub

    Public Sub Aleatorio()
        Dim nodos, vertices As Int16
        Dim lArrGraph1() As Int16
        Dim lArrGraph2() As Int16
        Dim nodo1, nodo2 As Int16
        Dim max, numvertice, repetir, i, j, usado As Int64
        Dim lfichsalida As String
        Dim Random As New Random()

        nodos = IDV_NODES3.Text

        If CInt(IDV_EDGES1.Text) > CInt(IDV_EDGES2.Text) Then
            MessageBox.Show("Bound 1 must be under bound 2")
            Return
        End If

        max = nodos * (nodos - 1) / 2
        If CInt(IDV_EDGES2.Text) > max Then
            MessageBox.Show("The graph can't have so many edges")
            Return
        End If

        vertices = Random.Next(IDV_EDGES1.Text, CInt(IDV_EDGES2.Text) + 1)
        ReDim lArrGraph1(vertices)
        ReDim lArrGraph2(vertices)

        repetir = IDV_REPEGEN3.Text

        For j = 0 To repetir - 1

            numvertice = 0

            If IDC_RC.Checked Then
                vertices = Random.Next(IDV_EDGES1.Text, CInt(IDV_EDGES2.Text) + 1)
                ReDim lArrGraph1(vertices)
                ReDim lArrGraph2(vertices)
            End If

            While True
                nodo1 = Random.Next(1, nodos + 1)
                nodo2 = Random.Next(1, nodos + 1)
                If nodo1 = nodo2 Then
                    Continue While
                End If

                usado = 0
                For i = 0 To vertices - 1
                    If lArrGraph1(i) = nodo1 And lArrGraph2(i) = nodo2 Then
                        usado = 1
                        Exit For
                    End If
                    If lArrGraph1(i) = nodo2 And lArrGraph2(i) = nodo1 Then
                        usado = 1
                        Exit For
                    End If
                Next

                If usado = 1 Then
                    Continue While
                End If

                lArrGraph1(numvertice) = nodo1
                lArrGraph2(numvertice) = nodo2
                numvertice = numvertice + 1
                If numvertice > vertices Then
                    Exit While
                End If
            End While

            lfichsalida = IDV_EXITDIR.Text + "\RANDOM" + CStr(j) + ".col"
            FileOpen(1, lfichsalida, OpenMode.Output, OpenAccess.Write, OpenShare.Default)
            FileSystem.PrintLine(1, "c random graph generated by the GIC San Sebastin")
            FileSystem.PrintLine(1, "c Israel Rebollo and Manuel Graa")
            FileSystem.PrintLine(1, "c Grupo de Inteligencia Computacional - Computational Imtelligence Group")
            FileSystem.PrintLine(1, "c http://www.ehu.es/ccwintco")
            FileSystem.PrintLine(1, "p edge " + CStr(nodos) + " " + CStr(vertices))


            Dim k, ordenauxA, ordenauxB As Int16

            For i = 0 To vertices - 2
                For k = i + 1 To vertices - 1
                    If lArrGraph1(i) > lArrGraph1(k) Then
                        ordenauxA = lArrGraph1(k)
                        ordenauxB = lArrGraph2(k)
                        lArrGraph1(k) = lArrGraph1(i)
                        lArrGraph2(k) = lArrGraph2(i)
                        lArrGraph1(i) = ordenauxA
                        lArrGraph2(i) = ordenauxB
                    End If
                Next
            Next

            For i = 0 To vertices - 1
                FileSystem.PrintLine(1, "e " + CStr(lArrGraph1(i)) + " " + CStr(lArrGraph2(i)))
            Next
            FileClose(1)

        Next

    End Sub

    Private Sub IDB_RANDOM_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IDB_RANDOM.Click
        IDB_RANDOM.Enabled = False
        Aleatorio()
        IDB_RANDOM.Enabled = True
    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click
        Dim direc As String
        Dim OpenDirectorio As New FolderBrowserDialog()
        OpenDirectorio.SelectedPath = "c:\temp\"
        OpenDirectorio.ShowDialog()
        direc = OpenDirectorio.SelectedPath

        IDV_EXITDIR.Text = direc
    End Sub

    Private Sub Button4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button4.Click
        Dim direc As String
        Dim OpenDirectorio As New FolderBrowserDialog()
        OpenDirectorio.SelectedPath = "c:\temp\"
        OpenDirectorio.ShowDialog()
        direc = OpenDirectorio.SelectedPath

        IDV_EXITDI.Text = direc

    End Sub


    Private Sub IDB_HELP_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles IDB_HELP.Click

        'Dim file As System.IO.File
        'file = file.Copy(My.Resources.help, "c:\temp\help.txt"))
        'Copy(My.Resources.help, "c:\temp\ayuda.txt")
        'Help.ShowHelp(Label1, "c:\temp\ayuda.txt")

    End Sub

    Public Sub btnBre_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnBre.Click
        Ejecutar("BRELAZ")
    End Sub
End Class

